package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TBFormQueryUtils;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 03/04/2017.
 * Search on database for results to fill in TB 11 Form Block 1 table 2
 */
public class TBForm11Block1Table2Query implements TbFormQuery {

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        List<Object[]> result = new ArrayList<Object[]>();
        String queryStr;

        // Total Registered - 0 is ordinal for TOTAL_REGISTERED in TBForm11.SuperColumn
        queryStr = " select 0, c.patientType, c.previouslyTreatedType, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) )"
                + " and c.state is not null and p.gender is not null and c.patientType is not null "
                + " and c.infectionSite = 0 and c.caseDefinition = 1 "
                + " group by c.patientType, c.previouslyTreatedType, p.gender ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());


        // Successfully Treated until 14 years old - 1 is ordinal for SUCCESSFULLY_TREATED_UNTIL_14 in TBForm11.SuperColumn
        queryStr = " select 1, c.patientType, c.previouslyTreatedType, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction%"
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) )"
                + " and c.classification = 0  and c.diagnosisType = 1 "
                + " and c.age <= 14 and c.state in (3,4) "
                + " and c.state is not null and p.gender is not null and c.patientType is not null "
                + " and c.infectionSite = 0 and c.caseDefinition = 1 "
                + " group by c.patientType, c.previouslyTreatedType, p.gender ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Successfully Treated after 14 years old - 2 is ordinal for SUCCESSFULLY_TREATED_AFTER_14 in TBForm11.SuperColumn
        queryStr = " select 2, c.patientType, c.previouslyTreatedType, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction%"
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) )"
                + " and c.classification = 0  and c.diagnosisType = 1 "
                + " and c.age > 14 and c.state in (3,4) "
                + " and c.state is not null and p.gender is not null and c.patientType is not null "
                + " and c.infectionSite = 0 and c.caseDefinition = 1 "
                + " group by c.patientType, c.previouslyTreatedType, p.gender ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Other outcomes - 3 is ordinal for OTHER_OUTCOMES in TBForm11.SuperColumn
        queryStr = " select 3, c.patientType, c.previouslyTreatedType, c.state, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction%"
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) )"
                + " and c.classification = 0  and c.diagnosisType = 1 "
                + " and c.state not in (3,4) "
                + " and c.state is not null and p.gender is not null and c.patientType is not null "
                + " and c.infectionSite = 0 and c.caseDefinition = 1 "
                + " group by c.patientType, c.previouslyTreatedType, c.state, p.gender ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        return result;
    }
}
